<?php 
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/costanti.php";
    include "include/util.php";
    include "gUtil/DbManager.php";
    include "gUtil/SocialSharer.php";
    include "gUtil/ControlloreStringhe.php";
    include "gUtil/GestoreTraduzioni.php";
    include "classi/GeneratoreUrl.php";
    include "classi/GestorePopup.php";
    include "classi/GestoreJavascript.php";
    include "classi/GeneratoreDatiStrutturati.php";
    include "template/stile.php";
    include "template/include/includeClassiTemplate.php";

    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);		
    $gestoreJavascript = new GestoreJavascript();

    $impostazioni          = recuperaImpostazioni($geecomDb);
    $impostazioniLingue    = $geecomDb->leggiSingolaRiga("geecB_impostazioniLingue", 1);
    $configurazioneAspetto = recuperaConfigurazioneColori($geecomDb);
    $inclusioni            = recuperaInclusioni($geecomDb);
    $datiBlog              = $geecomDb->leggiSingolaRiga("geec_blog", 1);
    
    // recupera lo stile scelto, la variabile aspettiSito è contenuta nel file stile.php
    $aspettoSito = $aspettiSito[$impostazioni["aspettoSito"]];
    
    // Avvia la sessione, serve per aumentare il numero delle visite e stabilire se mostrare
    // o meno la modalità manutenzione
    session_start();
    
    // se è impostata la modalità manutenzione = si l'utente non è loggato un viene caricata la pagina manutenzione
    if ($impostazioni["manutenzione"]=="si" && !isset($_SESSION["geecomAdmin_email"])) {            
        $contenuto = $geecomDb->leggiSingolaRiga("geecB_contenuti", $impostazioni["paginaManutenzione"]);
    }
    else if(isset($_GET["alias"]) && $_GET["alias"]=="") {     // se esiste un alias, ma è vuoto, viene mostrata la home. Serve quando viene impostata l'ottimizzazione seo
        $contenuto = recuperaHomePage($geecomDb,$impostazioni,$impostazioniLingue);
    }
    else if(!isset($_GET["alias"])) { // se non c'è alcun alias allora sta visualizzando la home page
        $contenuto = recuperaHomePage($geecomDb,$impostazioni,$impostazioniLingue);
    }
    else { //se il campo alias passato in input è contiene qualcosa allora fa la query
        $alias = filter_input(INPUT_GET,"alias",FILTER_SANITIZE_ADD_SLASHES);

        //prende i dati dell'articolo
        $contenuto = $geecomDb->leggiSingolaRiga("geecB_contenuti", $alias, "alias");
        if(!$contenuto) {
            unset($contenuto);
            include "template/include/paginaNonTrovata//index.php";
            exit();
        }

        // se il contenuto non è in pubblicato e non è visualizzato da un amministratore non viene mostrato
        if($contenuto["stato"]!="pubblicato" && !isset($_SESSION["geecomAdmin_email"])) {
            $datiCookie   = $geecomDb->leggiSingolaRiga("geecB_leggeCookie",$contenuto["linguaContenuto"],"lingua");
            include "template/include/paginaNonTrovata//index.php";
            exit();
        }
        
        //incrementa il numero di visite, controlla è l'amministratore a visualizzare l'articolo, in questo caso
        //non lo incrementa
        if(!isset($_SESSION["geecomAdmin_email"])) {
            $dataVisualizzazione = date("Y-m-d");
            $queryAggiornamentoVisite = "UPDATE geecB_contenuti SET numeroVisite=numeroVisite+1, dataUltimaVisita='$dataVisualizzazione' WHERE id={$contenuto["id"]}";
            $geecomDb->eseguiQueryScrittura($queryAggiornamentoVisite);

            incrementaConteggioVisite($geecomDb,$dataVisualizzazione);
        }
    }
    include "include/gestioneMultilingua.php";
    
    $gestoreTraduzioni  = new GestoreTraduzioni("localizzazione", array($lingua));
    $gestoreTraduzioni->caricaTraduzioni();
    $datiCookie         = $geecomDb->leggiSingolaRiga("geecB_leggeCookie",$lingua,"lingua");
    $profiliSocial      = $geecomDb->leggiSingolaRiga("geec_profiliSocial",1);
    $gestorePopup       = new GestorePopup($geecomDb, 0);
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <?php 
            echo $inclusioni["inizioHead"]; 
            if(isset($_COOKIE["leggecookie"])) echo $datiCookie["headCodiciCookie"];
        ?>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="robots" content="<?php echo (($impostazioni["consentiIndicizzazione"]=="si") ? "index, follow" : "noindex, nofollow"); ?>">
        <meta name="description" content="<?= ((isset($_GET["alias"])) ? $contenuto["metaDescrizione"] : $impostazioni["descrizioneSito"]); ?>" />
        <?php
            if($impostazioni["consentiIndicizzazione"]=="si") {    
                ?>
                <link rel="canonical" href="<?= ((isset($_GET["alias"])) ? GeneratoreUrl::creaUrlContenuto($contenuto, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]) : $impostazioni["urlSito"]); ?>"/>
                <?php
            }
        ?>
        <meta name="author" content="<?= $contenuto["autore"]; ?>">
        <meta name="generator" content="Geecom CMS" />

        <meta property="og:type" content="<?= ((isset($alias)) ? "article" : "website"); ?>">
        <meta property="og:title" content="<?= ((isset($alias)) ? str_replace('"',"",$contenuto["metaTitolo"]) : $impostazioni["titoloSito"]); ?>">
        <meta property="og:description" content="<?= ((isset($_GET["alias"])) ? $contenuto["metaDescrizione"] : $impostazioni["descrizioneSito"]); ?>">
        <meta property="og:url" content="<?= ((isset($alias)) ? GeneratoreUrl::creaUrlContenuto($contenuto, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlSito"]) : $impostazioni["urlSito"]); ?>">
        <meta property="og:image" content="<?= ($impostazioni["urlSito"]."/".$contenuto["foto"]); ?>"/>
        <meta property="og:image:width" content="640" />
        <meta property="og:image:height" content="480" />

        <title><?= ((isset($_GET["alias"]) && $_GET["alias"]!="") ? $contenuto["metaTitolo"]." - ".$impostazioni["titoloSito"] : $impostazioni["titoloEsteso"]); ?></title>

        <?php 
            include "include/includeCssBase.php";

            if($contenuto["cssAggiuntivo"]!="" || $contenuto["cssGenerato"]!="") {
                echo"<style type=text/css>
                {$contenuto["cssGenerato"]}
                {$contenuto["cssAggiuntivo"]}
                </style>";
            }
            echo $inclusioni["fineHead"]; 
            GeneratoreDatiStrutturati::esegui($contenuto, $impostazioni, $configurazioneAspetto);
        ?>
    </head>

    <body class="<?= $aspettoSito["body"]; ?> <?= (($impostazioni["attivaBarraSuperiore"]=="si") ? "extraspace" : ""); ?> <?= (($impostazioni["azzeraMargineSuperiore"]=="si") ? " bodyMargineSuperioreAzzerato" : ""); ?> <?= str_replace(".php","",$contenuto["template"]) ?>">
        <div class="thetop"></div>
        <?php 
            echo $inclusioni["inizioBody"];

            if(isset($_SESSION["geecomAdmin_email"])) {
                include "template/include/barraAdmin.php";
            }

            include "template/include/aspetto/{$aspettoSito["cartellaTemplatePagina"]}/templatePagina/{$contenuto["template"]}";

            // contiene la modal sulla legge dei cookie, la ricerca fullscreen ed eventuali
            // aggiunte del tema
            include"template/include/elementiAggiuntiviTemplate.php";

            //se è stata impostata stampa la popup
            $gestorePopup->stampaPopup();

            UtilTemplate::stampaScrollTop();

            include "include/includeJsBase.php";
            $gestorePopup->javascriptPopup(); //se è stata impostata la popup bisogna stampare il javascript associato

            if(isset($_COOKIE["leggecookie"])) echo $datiCookie["fineBodyCookie"];

            echo $inclusioni["fineBody"];
        ?>
    </body>
</html>